#!/bin/bash

# bash script to excute MAAT 
# this example/default script excutes a factorial MAAT run on a single core 
# this script is copied to $PDIR and should only be edited there to customise a run 
# Optional single argument - the MAAT runid, no argument will read 'init_MAAT.R' for initialisation, with argument <ARG> will read 'init_MAAT_<ARG>.R' for initialisation from $PDIR 

SDIR= #Source directory here (where you are running MAAT from)
PDIR= #Project directory here (where you are storing initialization scripts and output)
MOBJ="soil_decomp"

# command line arguments to pass to run_MAAT.R - argument names and options can be found in run_MAAT.R 
ARGS="srcdir<-'${SDIR}' pdir<-'${PDIR}' mod_obj<-'${MOBJ}' multic<-T uq<-F factorial<-T mdir<-'${PDIR}' metdata<-'met_year.csv'"



##########################################
### DO NOT MODIFY ANYTHING BELOW THIS LINE

# 1st argument - the MAAT runid
RUNID=$1

# date for labelling log files
YMD=`date +%Y-%m-%d`

LOGF="${PDIR}/logs/${YMD}_runlog.txt"
if [[ ! -z $RUNID ]]; then
  ARGS="${ARGS} runid<-'${RUNID}'" 
  LOGF="${PDIR}/logs/${YMD}_${RUNID}_runlog.txt"
fi

cd $SDIR
Rscript run_MAAT.R ${ARGS} > $LOGF



### END ###
