################################
#
# MAAT soil_decomp model - initialisation script
# 
# AWalker (walkerap@ornl.gov) 
# February 2018
# 
# Modified by M. Craig (craigme@ornl.gov)
# 2019
#
################################


###################################################################
### The MAAT model (Multi-Assumption Architecture & Testbed)
###################################################################

# This script initialises the soil_decomp version of MAAT
# - by setting the values of the init_static and init_dynamic lists
# - each of these lists elements are sublists named with the names of the model objects to which the variables in the sublists belong  
# - each of these model object sublist elements are sublists named with the type of variable they comprise - fnames, pars, or env  
# - each of these variables sublist elements are sublists named with the variable to which they refer in the model object  

# for example, to setup a leaf model object simulation:
# set static variables during runtime (init_static) by setting:
# - fnames.static
# - pars.static     
# - env.static


# set dynamic variables during runtime (init_dynamic) by setting:
# - fnames.var
# - pars.var     
# - env.var
# for a process SA two more sublists need to be added as elements to the init_dynamic$leaf list:
# - pars_proc and pars_eval, both with the same named elements
#   - pars_proc is a list of strings that associate each parameter with the process it is associated with, these should be one of the element names in the list init_dynamic$X$fnames
#   - pars_eval is a string that once evaluated gives a vector of parameter samples  


# This script must set the values of the above 6(8) lists, 
# if you do not want to set any values using these lists they must be specified as NA

###################################################################



### Define the functions, parameters, and environment variables that are to remain static through a simulation 
###############################

# define lists
fnames.static <- list(
  decomp = list(
    d1 = 'f_decomp_RMM_microbe',
    d3 = 'f_decomp_RMM_microbe'
  )
)

#pars reflect yearly timesteps

pars.static <- list(
  cue = list(
    cue1 = .47,  #CUE from MEND (Wang et al. 2013)
    cue2 = 1,    #NA; assuming mbc turnover is entirely transferred to MAOM pool
    cue3 = .47   #CUE from MEND (Wang et al. 2013)
  ),
 
   vmax = list(  
    vmax1 = 4,  #MIMICS average of two microbial groups assuming 15 degC (Wieder et al. 2014)   
    vmax3 = 6  #MIMICS average of two microbial groups assuming 15 degC (Wieder et al. 2014)  
  ),
  
  km = list(   
    km1 = 6,  #MIMICS average of two microbial groups for sturctural litter and biochemically protected SOC assuming 15 degC and 15%clay (Wieder et al. 2014)        
    km3 = 33   #MIMICS average of two microbial groups assuming 15 degC and lignin:N = 10 (Wieder et al. 2014)
  ),  
  
  k = list(   
    k2 = 2.5    #Li et al. 
  ),
  
  poolmax = list(       
    pmax1 = 2,      #NA
    pmax2 = 2,      #1.5 corresponds to about 97.5% quantile of mbc synthesis data 
    pmax3 = 27      #Calculated from Hassink and Whitmore 1997 assuming 20% clay
  ),
   
  beta = 1.5        #density-dependent turnover parameter from Georgiou et al. 2017
)

env.static  <- NULL #note that this model will be run using met_year.csv file ('year' must be specified for time in the met_data_translator)



### Define the functions, parameters, and environment variables that are to be varied 
###############################
# if this is a UQ analysis, the "pars" list must contain parameter vectors that are of equal length - need to put a check for this in the wrapper 
# if not a UQ analysis the parameter vectors in the "pars" list can be of different lengths
# set to NA where variation is not required  

# define lists
fnames.var <- list(
  transfer = list(t2_to_3 = c('f_transfer_cue', 'f_transfer_cue_sat'), #Mineral saturation alternative hypotheses
                  t1_to_2 = c('f_transfer_cue', 'f_transfer_cue_sat'), #1_to_2 and 3_to_2 are alternative microbial growth hypotheses
                  t3_to_2 = c('f_transfer_cue', 'f_transfer_cue_sat')),
  decomp = list(d2 = c('f_decomp_lin', 'f_decomp_dd'))                 #alternative microbial turnover hypotheses
)

pars.var <- NULL

pars_proc.var <- NULL

pars_eval.var <- NULL

env.var <- list(
  litter = c(1.40*.5, 1.40, 1.40*2, 1.40*4, 1.40*7, 1.40*10) #C input levels
)



### Combine the functions, parameters, and environment static and variable lists into a single list 
###############################

init_static <- list(
  fnames = list( soil_decomp = fnames.static),
  pars   = list( soil_decomp = pars.static),
  env    = list( soil_decomp = env.static)
)

init_dynamic <- list(
  fnames    = list( soil_decomp = fnames.var),
  pars      = list( soil_decomp = pars.var),
  pars_proc = list( soil_decomp = pars_proc.var),
  pars_eval = list( soil_decomp = pars_eval.var),
  env       = list( soil_decomp = env.var)
)



### END ###
